#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec2 vTexCoord;
out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform float brightness;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
    gl_FragColor = vec4(tColor.rgb * brightness, tColor.a);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
    fragColor = vec4(tColor.rgb * brightness, tColor.a);
#endif
}
